/* Copyright (C) 2016-2018 RealVNC Ltd.  All Rights Reserved.
 */

/* This is sample code intended to demonstrate part of the
 * VNC Mobile Solution SDK. It is not intended as a production-ready
 * component.
 */

#ifndef BASEDECODERLOGHANDLER_H_30924659696692549264630696896669351603
#define BASEDECODERLOGHANDLER_H_30924659696692549264630696896669351603

#include <cdfdecoder/vnccommondecoder.h>

#include <vnccommon/Log.h>


class BaseDecoderLogHandler : public vnccommon::LogHandler
{
    VNCCOMMON_DISALLOW_COPYING(BaseDecoderLogHandler)

public:
    BaseDecoderLogHandler(
            const VNCCommonDecoderSupportingAPI& supportingAPI,
            VNCCommonDecoderFrameworkContext frameworkContext);

    virtual void writeRaw(
            vnccommon::LogLevel level,
            const char* tag,
            const char* text);

private:
    const VNCCommonDecoderSupportingAPI& mSupportingAPI;
    VNCCommonDecoderFrameworkContext mFrameworkContext;
};

#endif // BASEDECODERLOGHANDLER_H_30924659696692549264630696896669351603

